#include "GetPoint.js"

function GetRectSecondPoint( factory, pointpicker  )
{
	var ui = moi.ui;

	ui.beginUIUpdate();
	ui.hideUI( 'FirstRectPrompt' );
	ui.showUI( 'LastRectPrompt' );
	ui.showUI( 'WidthHeight' );
	ui.endUIUpdate();

	factory.setInput( 0, pointpicker.ptframe );

	pointpicker.restrictToPlaneThroughPt( pointpicker.pt, false );
	pointpicker.disableVerticalStraightSnap = true;
	pointpicker.disableStraightSnapAngle( 0 );
	pointpicker.disableStraightSnapAngle( 90 );
	pointpicker.disableStraightSnapAngle( 180 );
	pointpicker.disableStraightSnapAngle( 270 );
	pointpicker.disableStraightSnapAngle( 360 );
	pointpicker.addStraightSnapAngle( 45, moi.ui.getText('Square snap') );
	
	pointpicker.bindResultPt( factory.getInput(1) );
	pointpicker.bindResultOrientation( factory.getInput(0) );
	pointpicker.bindFunc( ui.commandUI.OnPoint );

	var HaveWidth = false, HaveHeight = false;
	
	ui.commandUI.g_BasePt = pointpicker.pt;

	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return false;
			
		if ( pointpicker.event == 'finished' || pointpicker.event == 'done' )
		{
			break;
		}
		else if ( pointpicker.event == 'width' )
		{
			factory.setInput( 2, ui.commandUI.width.value );
			factory.update();
			
			HaveWidth = true;
			ui.commandUI.g_HaveWidth = true;
			pointpicker.clearStraightSnapAngles();
			pointpicker.addSnapFunc( factory, 'squareSnap' );
		}
		else if ( pointpicker.event == 'height' )
		{
			factory.setInput( 3, ui.commandUI.height.value );
			factory.update();
			
			HaveHeight = true;
			ui.commandUI.g_HaveHeight = true;
			pointpicker.clearStraightSnapAngles();
			pointpicker.addSnapFunc( factory, 'squareSnap' );
		}
		
		if ( HaveWidth && HaveHeight )
			break;
	}
	
	pointpicker.clearSnapFuncs();
	
	return true;
}

function GetRect( factory )
{
	var pointpicker = moi.ui.createPointPicker();

	if ( !GetPoint( pointpicker ) )
		return false;
		
	return GetRectSecondPoint( factory, pointpicker );
}

function GetRectCenter( factory )
{
	var pointpicker = moi.ui.createPointPicker();
	pointpicker.stickToSurfacesMode = 'max';

	if ( !GetPoint( pointpicker ) )
		return false;
		
	return GetRectSecondPoint( factory, pointpicker );
}
